package com.ejie.ab04b.service;

import com.ejie.ab04b.dao.FolderDao;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.model.Folder;

/**
 * Ab0477s00ServiceImpl generated by UDA, 07-jun-2017 11:54:50.
 * 
 * @author UDA
 */

@Service(value = "folderService")
public class FolderServiceImpl implements FolderService {

	@Autowired
	private FolderDao ab0477s00Dao;

	/**
	 * Inserts a single row in the Ab0477s00 table.
	 * 
	 *  ab0477s00
	 *            Ab0477s00
	 *  Ab0477s00
	 *
	 * @param ab0477s00 the ab 0477 s 00
	 * @return the folder
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Folder add(Folder ab0477s00) {
		return this.ab0477s00Dao.add(ab0477s00);
	}

	/**
	 * Updates a single row in the Ab0477s00 table.
	 * 
	 *  ab0477s00
	 *            Ab0477s00
	 *  Ab0477s00
	 *
	 * @param ab0477s00 the ab 0477 s 00
	 * @return the folder
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Folder update(Folder ab0477s00) {
		return this.ab0477s00Dao.update(ab0477s00);
	}
	
	/**
	 * Updates a single row in the Ab0477s00 table.
	 * 
	 *  ab0477s00
	 *            Ab0477s00
	 *  Ab0477s00
	 *
	 * @param ab0477s00 the ab 0477 s 00
	 * @return the folder
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Folder updateFolderId(Folder ab0477s00) {
		return this.ab0477s00Dao.updateFolderId(ab0477s00);
	}

	/**
	 * Finds a single row in the Ab0477s00 table.
	 * 
	 *  ab0477s00
	 *            Ab0477s00
	 *  Ab0477s00
	 *
	 * @param ab0477s00 the ab 0477 s 00
	 * @return the folder
	 */
	public Folder find(Folder ab0477s00) {
		return (Folder) this.ab0477s00Dao.find(ab0477s00);
	}
	
	/**
	 * Finds a single row in the Ab0477s00 table.
	 * 
	 *  ab0477s00
	 *            Ab0477s00
	 *  Ab0477s00
	 *
	 * @param ab0477s00 the ab 0477 s 00
	 * @return the folder
	 */
	public Folder findByPk(Folder ab0477s00) {
		return (Folder) this.ab0477s00Dao.findByPk(ab0477s00);
	}

	/**
	 * Deletes a single row in the Ab0477s00 table.
	 * 
	 *  ab0477s00
	 *            Ab0477s00
	 *
	 * @param ab0477s00 the ab 0477 s 00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Folder ab0477s00) {
		this.ab0477s00Dao.remove(ab0477s00);
	}

	/**
	 * Finds a list of rows in the Ab0477s00 table.
	 * 
	 *  ab0477s00
	 *            Ab0477s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Ab0477s00>
	 *
	 * @param ab0477s00 the ab 0477 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<Folder> findAll(Folder ab0477s00,
			JQGridRequestDto jqGridRequestDto) {
		return (List<Folder>) this.ab0477s00Dao.findAll(ab0477s00,
				jqGridRequestDto);
	}

	/**
	 * Finds rows in the Ab0477s00 table using like.
	 * 
	 *  ab0477s00
	 *            Ab0477s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Ab0477s00>
	 *
	 * @param ab0477s00 the ab 0477 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<Folder> findAllLike(Folder ab0477s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<Folder>) this.ab0477s00Dao.findAllLike(ab0477s00,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Ab0477s00 table.
	 * 
	 *  filterAb0477s00
	 *            Ab0477s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *
	 * @param filterAb0477s00 the filter ab 0477 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 */
	public void removeMultiple(Folder filterAb0477s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		this.ab0477s00Dao.removeMultiple(filterAb0477s00, jqGridRequestDto,
				startsWith);
	}

	/**
	 * Filter method in the Ab0477s00 table.
	 * 
	 *  filterAb0477s00
	 *            Ab0477s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<Ab0477s00>
	 *
	 * @param filterAb0477s00 the filter ab 0477 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<Folder> filter(Folder filterAb0477s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<Folder> listaAb0477s00 = this.ab0477s00Dao.findAllLike(
				filterAb0477s00, jqGridRequestDto, false);
		Long recordNum = this.ab0477s00Dao.findAllLikeCount(
				filterAb0477s00 != null ? filterAb0477s00 : new Folder(),
				false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Folder>> reorderSelection = this.ab0477s00Dao
					.reorderSelection(filterAb0477s00, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<Folder>(jqGridRequestDto,
					recordNum, listaAb0477s00, reorderSelection);
		}
		return new JQGridResponseDto<Folder>(jqGridRequestDto, recordNum,
				listaAb0477s00);
	}

	/**
	 * Searches rows in the Ab0477s00 table.
	 * 
	 *  filterAb0477s00
	 *            Ab0477s00
	 *  searchAb0477s00
	 *            Ab0477s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<Ab0477s00>>
	 *
	 * @param filterAb0477s00 the filter ab 0477 s 00
	 * @param searchAb0477s00 the search ab 0477 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<TableRowDto<Folder>> search(Folder filterAb0477s00,
			Folder searchAb0477s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return this.ab0477s00Dao.search(filterAb0477s00, searchAb0477s00,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Ab0477s00 table.
	 * 
	 *  filterAb0477s00
	 *            Ab0477s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterAb0477s00 the filter ab 0477 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	public Object reorderSelection(Folder filterAb0477s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.ab0477s00Dao.reorderSelection(filterAb0477s00,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Ab0477s00 table.
	 * 
	 *  filterAb0477s00
	 *            Ab0477s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<JerarquiaDto<Ab0477s00>>
	 *
	 * @param filterAb0477s00 the filter ab 0477 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<JerarquiaDto<Folder>> jerarquia(
			Folder filterAb0477s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		List<JerarquiaDto<Folder>> listaAb0477s00 = this.ab0477s00Dao
				.findAllLikeJerarquia(filterAb0477s00, jqGridRequestDto);
		Long recordNum = this.ab0477s00Dao.findAllLikeCountJerarquia(
				filterAb0477s00, jqGridRequestDto);
		return new JQGridResponseDto<JerarquiaDto<Folder>>(jqGridRequestDto,
				recordNum, listaAb0477s00);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the Ab0477s00 table.
	 * 
	 *  filterAb0477s00
	 *            Ab0477s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  JQGridResponseDto<JerarquiaDto<Ab0477s00>>
	 *
	 * @param filterAb0477s00 the filter ab 0477 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<JerarquiaDto<Folder>> jerarquiaChildren(
			Folder filterAb0477s00, JQGridRequestDto jqGridRequestDto) {
		JQGridResponseDto<JerarquiaDto<Folder>> jqGridResponseDto = new JQGridResponseDto<JerarquiaDto<Folder>>();
		jqGridResponseDto.addAdditionalParam(JQGridResponseDto.CHILDREN,
				this.ab0477s00Dao.findAllChild(filterAb0477s00,
						jqGridRequestDto));
		return jqGridResponseDto;
	}

}
